package com.example.skychasemk.controller;

import com.example.skychasemk.model.Notification;
import com.example.skychasemk.model.Wishlist;
import com.example.skychasemk.repository.NotificationRepository;
import com.example.skychasemk.services.NotificationService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Optional;

@RestController
@RequestMapping("/api/notifications")
public class NotificationController {
    @Autowired
    private NotificationService notificationService;

    @Autowired
    private NotificationRepository notificationRepository;

    @GetMapping("/{userId}")
    public ResponseEntity<List<Notification>> getAllNotifications(@PathVariable Integer userId) {
        List<Notification> notifications = notificationRepository.findByUser_UserId(Long.valueOf(userId));
        return ResponseEntity.ok(notifications);
    }

    @PostMapping
    public Notification createNotification(@RequestBody Notification notification) {
        return notificationService.saveNotification(notification);
    }

    @PutMapping("/{id}")
    public Notification updateNotification(@PathVariable("id") Integer notificationID, @RequestBody Notification notification) {
        return notificationService.updateNotification(notificationID, notification);
    }

    @DeleteMapping("/{id}")
    public void deleteNotification(@PathVariable("id") Integer notificationID) {
        notificationService.deleteNotification(notificationID);
    }
}
