package com.example.skychasemk.controller;

import com.example.skychasemk.model.BestValueFlight;
import com.example.skychasemk.service.BestValueFlightService;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;
import java.util.Map;

@RestController
public class ReportController {

    private final BestValueFlightService bestValueFlightService;

    public ReportController(BestValueFlightService bestValueFlightService) {
        this.bestValueFlightService = bestValueFlightService;
    }

    // Central reports function
    @GetMapping("/reports")
    public Map<String, Object> reports(String type) {
        switch (type) {
            case "bestValueFlights":
                List<BestValueFlight> flights = bestValueFlightService.getAllBestValueFlights();
                return Map.of("reportType", "Best Value Flights", "data", flights);
            // You can add more report types here
            default:
                return Map.of("error", "Invalid report type");
        }
    }


}
