package com.example.skychasemk.controller;

import com.example.skychasemk.dto.ReviewDTO;
import com.example.skychasemk.model.Booking;
import com.example.skychasemk.model.Flight;
import com.example.skychasemk.model.Review;
import com.example.skychasemk.repository.*;
import com.example.skychasemk.services.ReviewService;
import jakarta.transaction.Transactional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import java.time.LocalDateTime;
import java.util.List;

@RestController
@RequestMapping("/api/reviews")
public class ReviewController {

    @Autowired
    private ReviewService reviewService;

    @Autowired
    private ReviewRepository reviewRepository;

    @Autowired
    private BookingFlightRepository bookingFlightRepository;

    @Autowired
    private BookingRepository bookingRepository;

    @Autowired
    private FlightRepository flightRepository;

    @Autowired
    private ApplicationUserRepository userRepository;
    // Fetch flights booked by a user for reviews
    @GetMapping("/flights/user/{userId}")
    public List<Flight> getFlightsForUserReviews(@PathVariable Long userId) {
        return bookingFlightRepository.findFlightsByUserId(userId);
    }
    // Get all reviews
    @GetMapping
    public List<ReviewDTO> getAllReviews() {
        return reviewService.getAllReviews();
    }

    // Get reviews by flight
    @GetMapping("/flights/{flightId}")
    public ResponseEntity<List<Review>> getReviewsByFlightId(@PathVariable Integer flightId) {
        List<Review> reviews = reviewService.getReviewsByFlightId(flightId);
        return ResponseEntity.ok(reviews);
    }

    // Get reviews by airport
    @GetMapping("/airports/{airportId}")
    public ResponseEntity<List<Review>> getReviewsByAirportId(@PathVariable Integer airportId) {
        List<Review> reviews = reviewService.getReviewsByAirportId(airportId);
        return ResponseEntity.ok(reviews);
    }

    @PostMapping
    public Review submitReview(@RequestBody ReviewDTO dto) {
        return reviewService.submitReview(dto.getUserId(),
                Long.valueOf(dto.getTargetId()),
                dto.getReviewComment(),
                dto.getRating());
    }

    @PutMapping("/{id}")
    public Review updateReview(@PathVariable("id") Integer reviewID, @RequestBody Review review) {
        return reviewService.updateReview(reviewID, review);
    }

    // Delete a review
    @DeleteMapping("/{id}")
    public void deleteReview(@PathVariable("id") Integer reviewID) {
        reviewService.deleteReview(reviewID);
    }
}
