package com.example.skychasemk.dto;

import com.example.skychasemk.model.Flight;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.Date;

@Data
public class FlightDTO {
    private Integer flightID;
    private String flightNumber;
    private String departureCity;
    private String arrivalCity;
    private LocalDate departureDate;
    private LocalDate arrivalDate;
    private BigDecimal price;
    private Integer availableSeats;

    public FlightDTO(Flight f) {
        this.flightID = f.getFlightID();
        this.flightNumber = f.getFlightNumber();
        this.departureCity = f.getDepartureAirport().getDestination().getName();
        this.arrivalCity = f.getArrivalAirport().getDestination().getName();
        this.departureDate = f.getDepartureDate();
        this.arrivalDate = f.getReturnDate();
        this.price = f.getPrice();
        this.availableSeats = f.getAvailableSeats();
    }
    // getters and setters
}

