package com.example.skychasemk.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import jakarta.persistence.*;
import lombok.Data;
import lombok.NoArgsConstructor;
import java.util.List;

@Data
@NoArgsConstructor
@Entity
@Table(name = "airport")
public class Airport {

    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @Column(name = "airportid")
    private Integer id;

    @Column(name = "name", nullable = false)
    private String name;

    @Column(name = "country", nullable = false)
    private String country;

    @Column(name = "code", nullable = false, length = 5)
    private String code;

    @ManyToOne
    @JoinColumn(name = "destinationid", referencedColumnName = "destinationid")
    @JsonIgnore
    private Destination destination;

    @OneToMany(mappedBy = "departureAirport")
    @JsonIgnore
    private List<Flight> departures;

    @OneToMany(mappedBy = "arrivalAirport")
    @JsonIgnore
    private List<Flight> arrivals;
}
