package com.example.skychasemk.repository;

import com.example.skychasemk.model.Airport;
import com.example.skychasemk.model.Flight;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

import java.time.LocalDate;
import java.util.List;
import java.util.Optional;
@Repository
public interface FlightRepository extends JpaRepository<Flight, Integer> {
    Optional<Flight> findByFlightID(Integer flightID);

    @Query("""
        SELECT f FROM Flight f
        WHERE f.departureAirport.id IN :departureIds
          AND f.arrivalAirport.id IN :arrivalIds
          AND f.departureDate = :departureDate
          AND f.returnDate = :returnDate
    """)
    List<Flight> searchFlights(
            @Param("departureIds") List<Integer> departureIds,
            @Param("arrivalIds") List<Integer> arrivalIds,
            @Param("departureDate") LocalDate departureDate,
            @Param("returnDate") LocalDate returnDate
    );

    List<Flight> findByDepartureAirportAndArrivalAirportAndDepartureDate(
            Airport departureAirport, Airport arrivalAirport, LocalDate departureDate);
}
