package com.example.skychasemk.repository;

import com.example.skychasemk.model.Notification;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

import java.util.List;
@Repository
public interface NotificationRepository extends JpaRepository<Notification, Integer> {
    List<Notification> findByUser_UserId(Long userId);

    @Query("SELECT n FROM Notification n WHERE n.user.userId = :userId")
    List<Notification> findNotificationsByUserId(@Param("userId") Long userId);
}
