package com.example.skychasemk.repository;

import com.example.skychasemk.enums.TargetType;
import com.example.skychasemk.model.Review;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

import java.util.List;
@Repository
public interface ReviewRepository extends JpaRepository<Review, Integer> {

    @Query("SELECT r FROM Review r WHERE r.targetID = :targetId AND r.targetType = 'FLIGHT'")
    List<Review> findByFlightId(@Param("targetId") Integer flightId);

    @Query("SELECT r FROM Review r WHERE r.targetID = :targetId AND r.targetType = 'AIRPORT'")
    List<Review> findByAirportId(@Param("targetId") Integer airportId);

    @Query("SELECT r FROM Review r WHERE r.user.userId = :userId")
    List<Review> findByUserId(@Param("userId") Integer userId);

    List<Review> findByBooking_BookingID(Integer bookingId);
}
