package com.example.skychasemk.controller;

import com.example.skychasemk.model.Airport;
import com.example.skychasemk.services.AirportService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Optional;

@RestController
@RequestMapping("/api/airports")
public class AirportController {
    @Autowired
    private AirportService airportService;

    // Get all airports
    @GetMapping
    public List<Airport> getAllAirports() {
        return airportService.getAllAirports();
    }

    // Get airport by ID
    @GetMapping("/{id}")
    public Optional<Airport> getAirportById(@PathVariable("id") Integer airportID) {
        return Optional.ofNullable(airportService.getAirportById(airportID));
    }

    // Create a new airport
    @PostMapping
    public Airport createAirport(@RequestBody Airport airport) {
        return airportService.saveAirport(airport);
    }

    // Update an existing airport
    @PutMapping("/{id}")
    public Airport updateAirport(@PathVariable("id") Integer airportID, @RequestBody Airport airport) {
        return airportService.updateAirport(airportID, airport);
    }

    // Delete an airport
    @DeleteMapping("/{id}")
    public void deleteAirport(@PathVariable("id") Integer airportID) {
        airportService.deleteAirport(airportID);
    }
}
