package com.example.skychasemk.controller;

import com.example.skychasemk.dto.BookingDTO;
import com.example.skychasemk.model.ApplicationUser;
import com.example.skychasemk.model.Booking;
import com.example.skychasemk.repository.ApplicationUserRepository;
import com.example.skychasemk.services.BookingService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

@RestController
@RequestMapping("/api")
public class BookingController {

    private final BookingService bookingService;
    private final ApplicationUserRepository userRepository;

    @Autowired
    public BookingController(BookingService bookingService, ApplicationUserRepository userRepository) {
        this.bookingService = bookingService;
        this.userRepository = userRepository;
    }

    @PostMapping("/bookings")
    public Booking createBooking(@RequestBody Map<String, Object> payload) {
        Integer userId = (Integer) payload.get("userId");
        List<Integer> flightIds = (List<Integer>) payload.get("flightIds");
        BigDecimal totalCost = new BigDecimal(payload.get("totalCost").toString());

        // Find user
        ApplicationUser user = userRepository.findById(userId.longValue())
                .orElseThrow(() -> new RuntimeException("User not found"));

        // Map to BookingDTO
        BookingDTO dto = new BookingDTO();
        dto.setUser(user);
        dto.setFlights(flightIds);
        dto.setTotalCost(totalCost);

        return bookingService.createBooking(dto);
    }
}
