package com.example.skychasemk.controller;

import ch.qos.logback.core.status.Status;
import com.example.skychasemk.dto.SupportTicketDTO;
import com.example.skychasemk.enums.TicketStatus;
import com.example.skychasemk.model.SupportTicket;
import com.example.skychasemk.services.SupportTicketService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Optional;

@RestController
@RequestMapping("/api/support-tickets")
public class SupportTicketController {
    @Autowired
    private SupportTicketService supportTicketService;

    @GetMapping
    public List<SupportTicket> getAllTickets() {
        return supportTicketService.getAllTickets();
    }
    @GetMapping("/resolved")
    public List<SupportTicket> getResolvedTickets() {
        return supportTicketService.getResolvedTickets();
    }

    @GetMapping("/{id}")
    public Optional<SupportTicket> getTicketById(@PathVariable("id") Integer ticketID) {
        return Optional.ofNullable(supportTicketService.getTicketById(ticketID));
    }

    @PostMapping
    public ResponseEntity<SupportTicket> submitTicket(@RequestBody SupportTicketDTO dto) {
        SupportTicket ticket = supportTicketService.createTicket(dto);
        return ResponseEntity.ok(ticket);
    }

    @PutMapping("/{ticketId}/{status}")
    public ResponseEntity<SupportTicket> updateTicket(@PathVariable("ticketId") Integer ticketId, @PathVariable String status) {
        try {
            TicketStatus newStatus = TicketStatus.valueOf(status.toUpperCase());
            return ResponseEntity.ok(supportTicketService.updateTicket(ticketId, newStatus));
        } catch (IllegalArgumentException e) {
            return ResponseEntity.badRequest().build();
        }
    }



}
