package com.example.skychasemk.controller;

import com.example.skychasemk.dto.WishlistDTO;
import com.example.skychasemk.model.Wishlist;
import com.example.skychasemk.services.WishlistService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@RestController
@RequestMapping("/api/wishlists")
public class WishlistController {
    @Autowired
    private WishlistService wishlistService;

    @GetMapping
    public List<Wishlist> getAllWishlists() {
        return wishlistService.getAllWishlists();
    }

    @GetMapping("/{userId}")
    public ResponseEntity<List<Wishlist>> getWishlistForUser(@PathVariable Long userId) {
        List<Wishlist> wishlist = wishlistService.getWishlistForUser(userId);
        return ResponseEntity.ok(wishlist);
    }


    @PostMapping("/add")
    public ResponseEntity<Wishlist> addToWishlist(@RequestBody WishlistDTO wishlistRequest) {
        try {
            Wishlist saved = wishlistService.addToWishlist(wishlistRequest);
            return ResponseEntity.status(HttpStatus.CREATED).body(saved);
        } catch (Exception e) {
            return ResponseEntity.status(HttpStatus.BAD_REQUEST).build();
        }
    }

    @DeleteMapping
    public ResponseEntity<Void> deleteFromWishlist(@RequestParam("userId") Integer userId,
                                                   @RequestParam("targetId") Integer targetId) {
        wishlistService.removeFromWishlist(userId, targetId);
        return ResponseEntity.noContent().build();
    }


    @DeleteMapping("/{wishlistId}")
    public ResponseEntity<Void> deleteWishlistItem(@PathVariable Integer wishlistId) {
        wishlistService.deleteWishlistItem(wishlistId);
        return ResponseEntity.noContent().build();
    }
}
