package com.example.skychasemk.model;

import com.fasterxml.jackson.annotation.JsonManagedReference;
import jakarta.persistence.*;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

@Data
@NoArgsConstructor
@Entity
@Table(name = "flight")
public class Flight {
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Integer flightID;

    @Column(name = "flightnumber")
    private String flightNumber;

    @ManyToOne
    @JoinColumn(name = "departureairportid")
    private Airport departureAirport;

    @ManyToOne
    @JoinColumn(name = "arrivalairportid")
    private Airport arrivalAirport;

    @Column(name = "departuredate")
    private LocalDate departureDate;

    @Column(name = "returndate")
    private LocalDate returnDate;

    @Column(name="price")
    private BigDecimal price;

    @Column(name="availableseats")
    private Integer availableSeats;

    // Bookings relationship
    @ManyToMany(mappedBy = "flights")
    private List<Booking> bookings;

    // Wishlist relationship
    @ManyToMany(mappedBy = "flights")
    private Set<Wishlist> wishlists = new HashSet<>();

}

