package com.example.skychasemk.services;

import com.example.skychasemk.dto.FlightDTO;
import com.example.skychasemk.model.Airport;
import com.example.skychasemk.model.Flight;
import com.example.skychasemk.repository.AirportRepository;
import com.example.skychasemk.repository.FlightRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.time.LocalDate;
import java.util.List;
import java.util.stream.Collectors;
@Service
public class FlightService {

    @Autowired
    private FlightRepository flightRepository;

    @Autowired
    private AirportRepository airportRepository;

    public Flight getFlightById(Integer flightID) {
        return flightRepository.findById(flightID)
                .orElseThrow(() -> new RuntimeException("Flight not found with ID " + flightID));
    }

    public List<FlightDTO> getAllFlights() {
        return flightRepository.findAll().stream().map(FlightDTO::new).collect(Collectors.toList());
    }

    public List<Flight> searchFlights(String departureName, String arrivalName, LocalDate departureDate, LocalDate returnDate) {
        Airport departureAirport = airportRepository.findByNameIgnoreCase(departureName)
                .orElseThrow(() -> new RuntimeException("Departure airport not found: " + departureName));
        Airport arrivalAirport = airportRepository.findByNameIgnoreCase(arrivalName)
                .orElseThrow(() -> new RuntimeException("Arrival airport not found: " + arrivalName));

        List<Flight> flights = flightRepository.findByDepartureAirportAndArrivalAirportAndDepartureDate(
                departureAirport, arrivalAirport, departureDate
        );

        if (returnDate != null) {
            flights = flights.stream()
                    .filter(f -> returnDate.equals(f.getReturnDate()))
                    .collect(Collectors.toList());
        }

        return flights;
    }
}
