package com.example.skychasemk.controller;

import com.example.skychasemk.dto.DestinationDTO;
import com.example.skychasemk.services.DestinationService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@RestController
@RequestMapping("/api/destinations")
public class DestinationController {

    @Autowired
    private DestinationService destinationService;

    @GetMapping
    public ResponseEntity<List<DestinationDTO>> getAllDestinations() {
        List<DestinationDTO> destinations = destinationService.getAllDestinations();
        return ResponseEntity.ok(destinations);
    }

    @GetMapping("/{id}")
    public ResponseEntity<DestinationDTO> getDestinationById(@PathVariable("id") Integer destinationId) {
        DestinationDTO dto = destinationService.getDestinationById(destinationId);
        return ResponseEntity.ok(dto);
    }

    @PostMapping
    public ResponseEntity<DestinationDTO> createDestination(@RequestBody DestinationDTO dto) {
        DestinationDTO created = destinationService.createDestination(dto);
        return ResponseEntity.status(201).body(created);
    }

    @PutMapping("/{id}")
    public ResponseEntity<DestinationDTO> updateDestination(@PathVariable("id") Integer destinationId,
                                                            @RequestBody DestinationDTO dto) {
        DestinationDTO updated = destinationService.updateDestination(destinationId, dto);
        return ResponseEntity.ok(updated);
    }

    @DeleteMapping("/{id}")
    public ResponseEntity<Void> deleteDestination(@PathVariable("id") Integer destinationId) {
        destinationService.deleteDestination(destinationId);
        return ResponseEntity.noContent().build();
    }

    @GetMapping("/cities")
    public ResponseEntity<List<String>> getCities() {
        List<String> cities = destinationService.getAllCities();
        return ResponseEntity.ok(cities);
    }
}
