package com.example.skychasemk.controller;

import com.example.skychasemk.dto.FlightDTO;
import com.example.skychasemk.model.Flight;
import com.example.skychasemk.services.FlightService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import java.time.LocalDate;
import java.util.List;
import java.util.Optional;

@RestController
@RequestMapping("/api/flights")
public class FlightController {

    @Autowired
    private FlightService flightService;

    @GetMapping
    public List<FlightDTO> getAllFlights() {
        return flightService.getAllFlights();
    }

    @GetMapping("/{flightId}")
    public ResponseEntity<Flight> getFlightById(@PathVariable("flightId") Integer flightID) {
        Optional<Flight> flight = Optional.ofNullable(flightService.getFlightById(flightID));
        return flight.map(ResponseEntity::ok)
                .orElse(ResponseEntity.notFound().build());
    }

    @GetMapping("/search")
    public ResponseEntity<List<Flight>> searchFlights(
            @RequestParam String departureName,
            @RequestParam String arrivalName,
            @RequestParam @DateTimeFormat(iso = DateTimeFormat.ISO.DATE) LocalDate departureDate,
            @RequestParam(required = false) @DateTimeFormat(iso = DateTimeFormat.ISO.DATE) LocalDate returnDate
    ) {
        List<Flight> flights = flightService.searchFlights(departureName, arrivalName, departureDate, returnDate);

        if (flights.isEmpty()) {
            return ResponseEntity.noContent().build();
        }

        return ResponseEntity.ok(flights);
    }
}
