package com.example.skychasemk.model;

import jakarta.persistence.*;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

@Data
@NoArgsConstructor
@Entity
@Table(name = "administrator")
public class Administrator {

    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @Column(name = "admin_id")
    private Long adminId;

    @Column(name = "email", unique = true, nullable = false)
    private String email;

    // 1-M relationship: An Administrator can handle multiple SupportTickets
    @OneToMany(mappedBy = "administrator")
    private List<SupportTicket> supportTickets;
}
