package com.example.skychasemk.model;


import jakarta.persistence.*;
import lombok.Data;
import lombok.NoArgsConstructor;

@Entity
@Data
@NoArgsConstructor
@Table(name = "booking_flight")
public class BookingFlight {

    @EmbeddedId
    private BookingFlightId id;

    @ManyToOne
    @MapsId("bookingId")
    @JoinColumn(name = "bookingid")
    private Booking booking;

    @ManyToOne
    @MapsId("flightId")
    @JoinColumn(name = "flightid")
    private Flight flight;

    @Column(name = "seat_number")
    private Integer seatNumber;

    public BookingFlightId getId() {
        return id;
    }

    public void setId(BookingFlightId id) {
        this.id = id;
    }

    public Booking getBooking() {
        return booking;
    }

    public void setBooking(Booking booking) {
        this.booking = booking;
    }

    public Flight getFlight() {
        return flight;
    }

    public void setFlight(Flight flight) {
        this.flight = flight;
    }

    public Integer getSeatNumber() {
        return seatNumber;
    }

    public void setSeatNumber(Integer seatNumber) {
        this.seatNumber = seatNumber;
    }
}
