package com.example.skychasemk.model;

import com.fasterxml.jackson.annotation.JsonManagedReference;
import jakarta.persistence.*;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

@Entity
@Data
@NoArgsConstructor
@Table(name = "destination")
public class Destination {

    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @Column(name = "destinationid") // matches DB
    private Integer destinationId;

    @Column(name = "name", nullable = false)
    private String name;

    @Column(name = "country", nullable = false)
    private String country;

    @Column(name = "description", columnDefinition = "TEXT")
    private String description;

    @Column(name = "popularattraction", columnDefinition = "TEXT")
    private String popularAttraction;

    @Column(name = "besttimetovisit")
    private String bestTimeToVisit;

    // 1-M relationship: One Destination can have many Airports
    @OneToMany(mappedBy = "destination", cascade = CascadeType.ALL, orphanRemoval = true)
    @JsonManagedReference
    private List<Airport> airports;

    // M-N relationship: Wishlist includes Destinations
    @ManyToMany(mappedBy = "wishlistDestinations")
    private List<Wishlist> wishlists;
}
