package com.example.skychasemk.model;

import com.example.skychasemk.enums.NotificationType;
import jakarta.persistence.*;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.time.LocalDateTime;

@Data
@NoArgsConstructor
@Entity
@Table(name = "notification")
public class Notification {

    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @Column(name = "notificationid")
    private Integer notificationID;

    @ManyToOne
    @JoinColumn(name = "userid")
    private ApplicationUser user;

    @Column(name = "message")
    private String message;

    @Enumerated(EnumType.STRING)
    @Column(name="type")
    private NotificationType type;

    @Column(name = "datesent")
    private LocalDateTime dateSent;
}
