package com.example.skychasemk.model;

import com.example.skychasemk.enums.TargetType;
import jakarta.persistence.*;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.time.LocalDateTime;

@Data
@NoArgsConstructor
@Entity
@Table(name = "review")
public class Review {

    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @Column(name = "reviewid")
    private Integer reviewID;

    @ManyToOne
    @JoinColumn(name = "userid")
    private ApplicationUser user;

    @ManyToOne
    @JoinColumn(name = "bookingid")
    private Booking booking;

    @Column(name="targetid")
    private Integer targetID;

    @Enumerated(EnumType.STRING)
    @Column(name="targettype")
    private TargetType targetType;

    @Column(name = "reviewcomment")
    private String reviewComment;

    @Column(name="rating")
    private Integer rating;

    @Column(name="date")
    private LocalDateTime date;

    public void setTargetId(Long flightId) {
        this.targetID= Math.toIntExact(flightId);
    }
}
