package com.example.skychasemk.model;

import jakarta.persistence.*;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.time.LocalDateTime;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

@Data
@NoArgsConstructor
@Entity
@Table(name = "wishlist")
public class Wishlist {

    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @Column(name = "wishlistid")
    private Integer wishlistID;

    @ManyToOne
    @JoinColumn(name = "userid")
    private ApplicationUser user;

    @Column(name = "targetid")
    private Integer targetID;

    @Column(name = "dateadded")
    private LocalDateTime dateAdded;

    @ManyToMany
    @JoinTable(
            name = "wishlist_flight",
            joinColumns = @JoinColumn(name = "wishlistid"), // column in wishlist_flight referring to Wishlist
            inverseJoinColumns = @JoinColumn(name = "flightid") // column in wishlist_flight referring to Flight
    )
    private Set<Flight> flights = new HashSet<>();

    @ManyToMany
    @JoinTable(
            name = "wishlist_destination",
            joinColumns = @JoinColumn(name = "wishlist_id"),
            inverseJoinColumns = @JoinColumn(name = "destination_id")
    )
    private List<Destination> wishlistDestinations;
}
