package com.example.skychasemk.repository;

import com.example.skychasemk.model.Airport;
import com.example.skychasemk.model.Destination;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.stereotype.Repository;

import java.util.List;
import java.util.Optional;

@Repository
public interface AirportRepository extends JpaRepository<Airport, Integer> {
    List<Airport> findByDestination(Destination destination);
    Optional<Airport> findByCode(String code);
    Optional<Airport> findByNameIgnoreCase(String name);
}
