package com.example.skychasemk.repository;

import com.example.skychasemk.model.Booking;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

import java.util.List;
import java.util.Optional;

@Repository
public interface BookingRepository extends JpaRepository<Booking, Integer> {
    List<Booking> findByUser_UserId(Long userId);

    @Query("SELECT b FROM Booking b JOIN b.flights f WHERE f.flightID = :flightId")
    List<Booking> findBookingsByFlightId(@Param("flightId") Integer flightId);

    @Query("SELECT bf.booking FROM BookingFlight bf " +
            "WHERE bf.booking.user.userId = :userId AND bf.flight.flightID = :flightId")
    List<Booking> findBookingByUserIdAndFlightId(@Param("userId") Long userId,
                                                     @Param("flightId") Long flightId);
}
