package com.example.skychasemk.repository;

import com.example.skychasemk.model.Wishlist;
import jakarta.transaction.Transactional;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

import java.util.List;
import java.util.Optional;

@Repository
public interface WishlistRepository extends JpaRepository<Wishlist, Integer> {

    @Query("SELECT w FROM Wishlist w WHERE w.targetID = :targetId AND w.user.userId = :userId")
    Wishlist findByTargetIdAndUserId(@Param("targetId") Integer targetId, @Param("userId") Long userId);

    @Query("SELECT w FROM Wishlist w WHERE w.user.userId = :userId")
    List<Wishlist> findWishlistByUserId(@Param("userId") Long userId);

    @Modifying
    @Transactional
    @Query("DELETE FROM Wishlist w WHERE w.user.userId = :userId AND w.targetID = :targetId")
    void deleteByUserIdAndTargetId(@Param("userId") Long userId, @Param("targetId") Integer targetId);

    @Query("SELECT w.targetID FROM Wishlist w WHERE w.wishlistID = :wishlistId")
    Optional<Integer> getFlightFromWishlist(@Param("wishlistId") Integer wishlistId);
}
