package com.example.skychasemk.services;

import com.example.skychasemk.dto.ApplicationUserDTO;
import com.example.skychasemk.dto.ApplicationUserLoginDTO;
import com.example.skychasemk.model.ApplicationUser;
import com.example.skychasemk.repository.ApplicationUserRepository;
import jakarta.transaction.Transactional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Optional;

@Service
public class ApplicationUserService {

    @Autowired
    private ApplicationUserRepository userRepository;

    @Transactional
    public ApplicationUser registerUser(ApplicationUserDTO userDTO) {
        if (userRepository.findByEmail(userDTO.getEmail()).isPresent()) {
            throw new RuntimeException("Email already registered");
        }

        ApplicationUser user = new ApplicationUser();
        user.setName(userDTO.getName());
        user.setSurname(userDTO.getSurname());
        user.setEmail(userDTO.getEmail());
        user.setPassword(userDTO.getPassword());
        user.setPhoneNumber(userDTO.getPhone_number());

        return userRepository.save(user);
    }

    public ApplicationUser loginUser(ApplicationUserLoginDTO loginDTO) {
        ApplicationUser user = userRepository.findByEmail(loginDTO.getEmail())
                .orElseThrow(() -> new RuntimeException("User not registered"));

        if (!loginDTO.getPassword().equals(user.getPassword())) {
            throw new RuntimeException("Invalid credentials");
        }
        return user;
    }

    public Optional<ApplicationUser> findByEmail(String email) {
        return userRepository.findByEmail(email);
    }
}
