package com.example.skychasemk.services;

import com.example.skychasemk.model.Notification;
import com.example.skychasemk.repository.NotificationRepository;
import jakarta.transaction.Transactional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
public class NotificationService {

    @Autowired
    private NotificationRepository notificationRepository;

    public List<Notification> getAllNotifications(Long userId) {
        return notificationRepository.findByUser_UserId(userId);
    }

    public Notification getNotificationById(Integer id) {
        return notificationRepository.findById(id)
                .orElseThrow(() -> new RuntimeException("Notification not found with ID " + id));
    }

    @Transactional
    public Notification saveNotification(Notification notification) {
        return notificationRepository.save(notification);
    }

    @Transactional
    public Notification updateNotification(Integer id, Notification notificationDetails) {
        Notification existing = notificationRepository.findById(id)
                .orElseThrow(() -> new RuntimeException("Notification not found with ID " + id));

        existing.setMessage(notificationDetails.getMessage());
        existing.setType(notificationDetails.getType());
        existing.setDateSent(notificationDetails.getDateSent());

        return notificationRepository.save(existing);
    }

    @Transactional
    public void deleteNotification(Integer id) {
        if (!notificationRepository.existsById(id)) {
            throw new RuntimeException("Notification not found with ID " + id);
        }
        notificationRepository.deleteById(id);
    }
}
