package com.example.skychasemk.dto;

import com.example.skychasemk.model.Booking;
import lombok.Getter;
import lombok.Setter;

import java.math.BigDecimal;
import java.time.LocalDate;

public class PaymentDTO {

    // Getters and Setters
    @Setter
    @Getter
    private Long paymentID;
    @Getter
    private Integer bookingId;
    @Setter
    private Integer userId;
    @Setter
    @Getter
    private PaymentMethod method;
    @Setter
    @Getter
    private BigDecimal amount;
    @Getter
    private LocalDate transactionDate;
    @Setter
    @Getter
    private PaymentStatus status;
    @Setter
    @Getter
    private Long flightId;

    public enum PaymentStatus {
        PENDING,
        COMPLETED,
        CANCELLED
    }

    public enum PaymentMethod {
        PAYPAL,
        DEBIT,
        CREDIT
    }


    public Long getUserId() {
        return Long.valueOf(userId);
    }

}

