package com.example.skychasemk.model;

import jakarta.persistence.*;
import lombok.Getter;
import lombok.Setter;

import java.math.BigDecimal;
import java.time.LocalDate;

@Entity
@Table(name="booking")
public class Booking {

    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @Column(name = "bookingid")

    private Integer bookingId;
    @Column(name = "userid")

    private Integer userId;

    @Column(name = "booking_date")

    private LocalDate booking_date;

    @Column(name = "payment_status")

    @Enumerated(EnumType.STRING)
    private payment_status status;
    @Column(name = "total_cost")

    private BigDecimal total_cost;
    @Column(name = "seat_number")

    private Integer seat_number;

    @Column(name = "flightid")
    private Integer flightId;

    public Integer getFlightId() {
        return flightId;
    }

    public void setFlightId(Integer flightId) {
        this.flightId = flightId;
    }

    public enum payment_status {
        PENDING,
        COMPLETED,
        CANCELLED
    }

    public LocalDate getBookingDate() {
        return booking_date;
    }

    public Integer getBookingId() {
        return bookingId;
    }

    public void setBookingId(Integer bookingID) {
        this.bookingId = bookingID;
    }

    public Integer getUserId() {
        return userId;
    }

    public void setUserId(Integer userId) {
        this.userId = userId;
    }

    public LocalDate getBooking_date() {
        return booking_date;
    }

    public void setBooking_date(LocalDate booking_date) {
        this.booking_date = booking_date;
    }

    public payment_status getStatus() {
        return status;
    }

    public void setStatus(payment_status status) {
        this.status = status;
    }

    public BigDecimal getTotal_cost() {
        return total_cost;
    }

    public void setTotal_cost(BigDecimal total_cost) {
        this.total_cost = total_cost;
    }

    public Integer getSeat_number() {
        return seat_number;
    }

    public void setSeat_number(Integer seat_number) {
        this.seat_number = seat_number;
    }

    public void setBookingDate(LocalDate bookingDate) {
        this.booking_date = bookingDate;
    }

    public Integer getSeatNumber() {
        return seat_number;
    }

    public void setSeatNumber(Integer seat_number) {
        this.seat_number = seat_number;
    }
}
