package com.example.skychasemk.model;

import jakarta.persistence.*;
import lombok.Getter;
import lombok.Setter;

import java.math.BigDecimal;
import java.time.LocalDate;

@Getter
@Entity
@Table(name="Payment")
public class Payment {

    @Setter
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @Column(name = "PaymentID")

    private Integer paymentID;

    //@Column(name = "bookingId")
    @Setter
    @Column(name="bookingid")
    private Integer bookingId;
    @Getter
    @Column(name = "userid")

    private Integer userId;
    @Setter
    @Column(name = "payment_method")

    @Enumerated(EnumType.STRING)
    private PaymentMethod method;
    @Setter
    @Column(name = "Amount")

    private BigDecimal amount;
    @Setter
    @Getter
    @Column(name = "transaction_date")

    private LocalDate transactionDate;
    @Setter
    @Getter
    @Column(name = "payment_status")

    @Enumerated(EnumType.STRING)
    private PaymentStatus status;


    public enum PaymentStatus {
        PENDING,
        COMPLETED,
        CANCELLED
    }

    public enum PaymentMethod {
        PAYPAL,
        DEBIT,
        CREDIT
    }

    public Integer getBookingID() {
        return bookingId;
    }

    public void setUserID(Integer userId) {
        this.userId = userId;
    }

    public void setUserId(Long userId) {
        this.userId = Math.toIntExact(userId);
    }

}

