package com.example.skychasemk.services;

import com.example.skychasemk.model.Booking;
import com.example.skychasemk.repository.BookingRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Optional;

import static com.example.skychasemk.model.Booking.payment_status.COMPLETED;


@Service
public class BookingService {

    @Autowired
    private BookingRepository bookingRepository;

    public List<Booking> getAllBookings() {
        return bookingRepository.findAll();
    }

    public Optional<Booking> getBookingById(Integer bookingID) {
        return bookingRepository.findById(bookingID);
    }

    public Booking saveBooking(Booking booking) {
        return bookingRepository.save(booking);
    }

    public Booking updateBooking(Integer bookingID, Booking booking) {
        if (bookingRepository.existsById(bookingID)) {
            booking.setStatus(COMPLETED);
            booking.setUserId(booking.getUserId());
            booking.setTotal_cost(booking.getTotal_cost());
            booking.setFlightId(booking.getFlightId());
            booking.setBooking_date(booking.getBooking_date());
            return bookingRepository.save(booking);
        } else {
            throw new RuntimeException("Booking not found with id " + bookingID);
        }
    }

    public void deleteBooking(Integer bookingID) {
        bookingRepository.deleteById(bookingID);
    }

}

