package com.example.skychasemk.model;

import com.example.skychasemk.enums.PaymentMethod;
import com.example.skychasemk.enums.PaymentStatus;
import com.fasterxml.jackson.annotation.JsonBackReference;
import com.fasterxml.jackson.annotation.JsonIgnore;
import jakarta.persistence.*;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.math.BigDecimal;
import java.time.LocalDateTime;

@Data
@NoArgsConstructor
@Entity
@Table(name = "payment")
public class Payment {
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @Column(name = "paymentid")
    private Integer paymentID;

    @OneToOne
    @JoinColumn(name = "bookingid")
    @JsonBackReference
    private Booking booking;

    @ManyToOne
    @JoinColumn(name = "userid")
    @JsonIgnore
    private ApplicationUser user;

    @Enumerated(EnumType.STRING)
    @Column(name = "paymentmethod")
    private PaymentMethod paymentMethod;

    @Column(name = "amount")
    private BigDecimal amount;

    @Column(name = "transactiondate")
    private LocalDateTime transactionDate;

    @Enumerated(EnumType.STRING)
    @Column(name = "paymentstatus")
    private PaymentStatus paymentStatus;
}
