package com.example.skychasemk.model;

import com.example.skychasemk.enums.TicketStatus;
import jakarta.persistence.*;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.time.LocalDateTime;

@Data
@NoArgsConstructor
@Entity
@Table(name = "supportticket")
public class SupportTicket {

    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @Column(name = "ticketid")
    private Integer ticketID;

    @ManyToOne
    @JoinColumn(name = "userid")
    private ApplicationUser user;

    @Column(name="subject")
    private String subject;

    @Column(name = "description")
    private String description;

    @Enumerated(EnumType.STRING)
    @Column(name="status")
    private TicketStatus status;

    @Column(name = "datecreated")
    private LocalDateTime dateCreated;

    @Column(name = "dateresolved")
    private LocalDateTime dateResolved;

    @ManyToOne
    @JoinColumn(name = "assignedto")
    private Administrator administrator;
}
