package com.example.skychasemk.repository;

import com.example.skychasemk.model.BookingFlight;
import com.example.skychasemk.model.BookingFlightId;
import com.example.skychasemk.model.Flight;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;
import java.util.List;

@Repository
public interface BookingFlightRepository extends JpaRepository<BookingFlight, BookingFlightId> {
    List<BookingFlight> findByBooking_BookingID(Integer bookingId);
    List<BookingFlight> findByFlight_FlightID(Integer flightId);

    @Query("SELECT bf.flight FROM BookingFlight bf WHERE bf.booking.user.userId = :userId")
    List<Flight> findFlightsByUserId(@Param("userId") Long userId);
}
