package com.example.skychasemk.repository;

import com.example.skychasemk.model.SupportTicket;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.stereotype.Repository;

import java.util.List;
@Repository
public interface SupportTicketRepository extends JpaRepository<SupportTicket, Integer> {
    List<SupportTicket> findByUser_UserId(Long userId);
    List<SupportTicket> findByAdministrator_AdminId(Long adminId);

    @Query("SELECT s FROM SupportTicket s WHERE s.status = 'RESOLVED'")
    List<SupportTicket> findResolvedTickets();
}
