package com.example.skychasemk.services;

import com.example.skychasemk.model.Airport;
import com.example.skychasemk.repository.AirportRepository;
import jakarta.transaction.Transactional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
@Service
public class AirportService {

    private final AirportRepository airportRepository;

    @Autowired
    public AirportService(AirportRepository airportRepository) {
        this.airportRepository = airportRepository;
    }

    public List<Airport> getAllAirports() {
        return airportRepository.findAll();
    }

    public Airport getAirportById(Integer id) {
        return airportRepository.findById(id)
                .orElseThrow(() -> new RuntimeException("Airport not found with id " + id));
    }

    @Transactional
    public Airport saveAirport(Airport airport) {
        return airportRepository.save(airport);
    }

    @Transactional
    public Airport updateAirport(Integer id, Airport airport) {
        Airport existing = airportRepository.findById(id)
                .orElseThrow(() -> new RuntimeException("Airport not found with id " + id));

        existing.setName(airport.getName());
        existing.setCountry(airport.getCountry());
        existing.setCode(airport.getCode());
        existing.setDestination(airport.getDestination());

        return airportRepository.save(existing);
    }

    @Transactional
    public void deleteAirport(Integer id) {
        if (!airportRepository.existsById(id)) {
            throw new RuntimeException("Airport not found with id " + id);
        }
        airportRepository.deleteById(id);
    }
}
