INSERT INTO ApplicationUser (Name,Surname,Email,Password,PhoneNumber,DateJoined)
VALUES
    ('Stefani','Jovanoska','stefani@example.com','Password123','078123456','2025-01-01'),
    ('Marko','Petrov','marko@example.com','Password123','078654321','2025-02-01'),
    ('Ana','Stojanov','ana@example.com','Password123','078987654','2025-03-01');

INSERT INTO Destination (Name,Country,Description,PopularAttraction,BestTimeToVisit)
VALUES
    ('Skopje','Macedonia','Capital city','Old Bazaar','Spring'),
    ('Ohrid','Macedonia','Lake city','Lake Ohrid','Summer'),
    ('Bansko','Bulgaria','Ski resort','Ski slopes','Winter');

INSERT INTO Airport (Name,Country,Code,DestinationID)
VALUES
    ('Skopje','Macedonia','SKP',1),
    ('Ohrid','Macedonia','OHD',2),
    ('Bansko','Bulgaria','BAN',3);

INSERT INTO Flight (FlightNumber,DepartureAirportID,ArrivalAirportID,departuredate,returndate,Price,AvailableSeats)
VALUES
    ('MK101',1,2,'2025-05-01' ,'2025-05-01',150.00,100),
    ('MK102',2,1,'2025-05-02','2025-05-02',150.00,80),
    ('MK103',1,3,'2025-05-03','2025-05-03',200.00,50);

INSERT INTO Booking (UserID,BookingDate,PaymentStatus,TotalCost)
VALUES
    (1,'2025-05-01 10:00','Processing',150.00),
    (2,'2025-05-02 14:00','Success',150.00),
    (3,'2025-05-03 16:00','Failed',200.00);

INSERT INTO BookingFlight (BookingID,FlightID,SeatNumber)
VALUES
    (1,1,1),
    (2,2,2),
    (3,3,3);

INSERT INTO Review (UserID,BookingID,TargetID,TargetType,ReviewComment,Rating,Date)
VALUES
    (1,1,1,'Flight','Great flight',5,'2025-05-01'),
    (2,2,2,'Flight','On time',4,'2025-05-02'),
    (3,3,3,'Flight','Comfortable','5','2025-05-03');

INSERT INTO Payment (BookingID,UserID,PaymentMethod,Amount,TransactionDate,PaymentStatus)
VALUES
    (1,1,'Credit',150.00,'2025-05-01','Processing'),
    (2,2,'PayPal',150.00,'2025-05-02','Success'),
    (3,3,'Debit',200.00,'2025-05-03','Failed');

INSERT INTO Notification (UserID,Message,Type,DateSent)
VALUES
    (1,'Your flight is confirmed','BookingConfirmation','2025-05-01'),
    (2,'Flight delayed','FlightDelay','2025-05-02'),
    (3,'Welcome to TravelApp','GeneralUpdate','2025-05-03');

INSERT INTO Wishlist (UserID,TargetID,TargetType,DateAdded)
VALUES
    (1,2,'Destination','2025-05-01'),
    (2,3,'Flight','2025-05-02'),
    (3,1,'Destination','2025-05-03');

INSERT INTO Administrator (Email)
VALUES
    ('admin1@example.com'),
    ('admin2@example.com');

INSERT INTO SupportTicket (UserID,Subject,Description,Status,DateCreated,AssignedTo)
VALUES
    (1,'Issue with booking','Booking not confirmed','Open','2025-05-01',1),
    (2,'Flight delay inquiry','Delayed flight','InProgress','2025-05-02',2);