INSERT INTO ApplicationUser (UserID, Name, Surname, Email, Password, PhoneNumber, DateJoined)
VALUES 
(1, 'Alice', 'Johnson', 'alice.johnson@email.com', 'pass123', '1234567890', '2023-01-15'),
(2, 'Bob', 'Smith', 'bob.smith@email.com', 'securepass', '0987654321', '2023-02-20');

INSERT INTO Destination (DestinationID, Name, Country, Description, PopularAttraction, BestTimeToVisit)
VALUES 
(1, 'Paris', 'France', 'City of Love and Lights', 'Eiffel Tower', 'Spring & Autumn'),
(2, 'Tokyo', 'Japan', 'Blend of modern and traditional culture', 'Shibuya Crossing', 'March to May, September to November');

INSERT INTO Airport (AirportID, Name, CityID, Country, Code)
VALUES 
(1, 'Charles de Gaulle Airport', 1, 'France', 'CDG'),
(2, 'Narita International Airport', 2, 'Japan', 'NRT');

INSERT INTO Flight (FlightID, FlightNumber, DepartureAirport, ArrivalAirport, DepartureTime, ArrivalTime, Price, AvailableSeats)
VALUES 
(1, 'AF123', 1, 2, '10:30:00', '23:45:00', 850.00, 150),
(2, 'JL456', 2, 1, '15:00:00', '05:30:00', 900.00, 120);

INSERT INTO Booking (BookingID, UserID, FlightID, BookingDate, PaymentStatus, TotalCost, SeatNumber)
VALUES 
(1, 1, 1, '2024-02-10', 'Completed', 850.00, 12),
(2, 2, 2, '2024-02-12', 'Pending', 900.00, 23);

INSERT INTO Review (ReviewID, UserID, TargetID, ReviewComment, Rating, Date)
VALUES 
(1, 1, 1, 'Amazing flight, very comfortable!', 5, '2024-02-15'),
(2, 2, 2, 'Decent flight but could be better.', 3, '2024-02-18');

INSERT INTO Payment (PaymentID, BookingID, UserID, PaymentMethod, Amount, TransactionDate, PaymentStatus)
VALUES 
(1, 1, 1, 'Credit card', 850.00, '2024-02-10', 'Success'),
(2, 2, 2, 'PayPal', 900.00, '2024-02-12', 'Processing');

INSERT INTO Notification (NotificationID, UserID, Message, Type, DateSent)
VALUES 
(1, 1, 'Your booking is confirmed!', 'Booking confirmation', '2024-02-10'),
(2, 2, 'Your flight is delayed by 1 hour.', 'Flight delay', '2024-02-13');

INSERT INTO Wishlist (WishlistID, UserID, TargetID, DateAdded)
VALUES 
(1, 1, 1, '2024-02-05'),
(2, 2, 2, '2024-02-07');

INSERT INTO Administrator (AdminID, Email)
VALUES 
(1, 'admin1@voyago.com'),
(2, 'admin2@voyago.com');

INSERT INTO SupportTicket (TicketID, UserID, Subject, Description, Status, DateCreated, DateResolved, AssignedTo)
VALUES 
(1, 1, 'Refund Request', 'I need a refund for my flight.', 'Open', '2024-02-11', NULL, 1),
(2, 2, 'Lost Baggage', 'My luggage was lost during transit.', 'In progress', '2024-02-14', NULL, 2);
