-- 1. Check bookings by user
EXPLAIN ANALYZE
SELECT *
FROM Booking
WHERE UserID = 1;

-- Create index and recheck
CREATE INDEX IF NOT EXISTS idx_booking_user ON Booking(UserID);

EXPLAIN ANALYZE
SELECT *
FROM Booking
WHERE UserID = 1;


-- 2. Check flights by departure time
EXPLAIN ANALYZE
SELECT *
FROM Flight
WHERE DepartureTime BETWEEN '2025-05-01' AND '2025-06-01';

-- Create index and recheck
CREATE INDEX IF NOT EXISTS idx_flight_departuretime ON Flight(DepartureTime);

EXPLAIN ANALYZE
SELECT *
FROM Flight
WHERE DepartureTime BETWEEN '2025-05-01' AND '2025-06-01';


-- 3. Check payments by booking
EXPLAIN ANALYZE
SELECT *
FROM Payment
WHERE BookingID = 5;

-- Create index and recheck
CREATE INDEX IF NOT EXISTS idx_payment_booking ON Payment(BookingID);

EXPLAIN ANALYZE
SELECT *
FROM Payment
WHERE BookingID = 5;


-- 4. Check reviews by user
EXPLAIN ANALYZE
SELECT *
FROM Review
WHERE UserID = 2;

-- Create index and recheck
CREATE INDEX IF NOT EXISTS idx_review_user ON Review(UserID);

EXPLAIN ANALYZE
SELECT *
FROM Review
WHERE UserID = 2;


-- 5. Check reviews by target (type + id)
EXPLAIN ANALYZE
SELECT *
FROM Review
WHERE TargetType = 'Destination' AND TargetID = 3;

-- Create index and recheck
CREATE INDEX IF NOT EXISTS idx_review_target_type_id ON Review(TargetType, TargetID);

EXPLAIN ANALYZE
SELECT *
FROM Review
WHERE TargetType = 'Destination' AND TargetID = 3;
