package finki.db.tasty_tabs.entity;
import jakarta.persistence.*;
import jakarta.persistence.Table;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

/**
 * Entity: Category
 * Description: Represents product categories.
 */
@Entity
@Table(name = "categories")
@Data
@NoArgsConstructor
public class Category {

    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Long id;

    @Column(name = "name", nullable = false, unique = true)
    private String name;

    @Column(name = "is_available")
    private Boolean isAvailable;

    @OneToMany(mappedBy = "category")
    private List<Product> products;

    public Category(String name, Boolean isAvailable) {
        this.name=name;
        this.isAvailable=isAvailable;
    }
}
