@extends("layouts.auth")

@section("title", "Verify | TechnoBlog")

@section("auth_content")
	<div class="page">
		<div class="page-single">
			<div class="container">
				<div class="row">
					<div class="col col-login mx-auto">
						<div class="text-center mb-6">
							<img src="/assets/images/logo1.png">
						</div>

						<form class="card" action="{{ route("auth.verify", ["id" => $id, "token" => $token]) }}" method="post">

							@csrf

							<div class="card-body p-6">

                                <div class="card-title">Verify your new e-mail address</div>

                                @if ($errors->any())
									<div class="alert alert-danger">
										<ul class="m-0 pl-2">
											@foreach ($errors->all() as $error)
												<li>{{ $error }}</li>
											@endforeach
										</ul>
									</div>
								@endif

								<div class="form-group">
									<label class="form-label">Security Code</label>
									<input type="text" class="form-control" name="security_code" autocomplete="off" required>
								</div>

								<div class="form-footer">
									<input type="submit" value="Verify" class="btn btn-primary btn-block">
								</div>

							</div>
						</form>
					</div>
				</div>
			</div>
		</div>
	</div>
@endsection
