<?php

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Support\Str;
use Illuminate\Database\Eloquent\Model;

class Post extends Model
{
	protected $table = "posts";

	protected $fillable = ["title", "image_link", "content", "user_id", "category_id"];

	public function user() {
		return $this->belongsTo(User::class);
	}

	public function category() {
		return $this->belongsTo(Category::class);
	}

	public function tag()
	{
		return $this->belongsToMany(Tag::class, "posts_tags");
	}

	public function comment() {
		return $this->hasMany(Comment::class);
	}

	public function like()
	{
		return $this->hasMany(Like::class);
	}

	public function getConfirmedBy() {
		return User::find($this->confirmed_by)->getFullName();
	}

	public function ago() {
		return Carbon::parse($this->created_at)->diffForHumans();
	}

	public function createSlug($isEdit = false) {

		$newSlug = Str::slug($this->title);
		$slugs = Post::pluck("slug");

		if($isEdit) {
			return $newSlug;
		}

		if($slugs->contains($newSlug)) {
			$id = $this->latest("id")->first()->id + 1;
			$newSlug = $newSlug . "-" . $id;
		}

		return $newSlug;
	}

	public function isLiked($ipAddress) {

		$likes = $this->like->all();

		foreach($likes as $like) {
			if($this->id == $like->post_id && $ipAddress == $like->ip_address) {
				return true;
			}
		}

		return false;
	}
}
