require(['jquery', 'Noty'], function($, Noty) {
    $(function() {
        window.alert = {
            show: function (message, type = "success", layout = "topRight", theme = "sunset") {
                new Noty({
                    type: type,
                    layout: layout,
                    text: message,
                    theme: theme,
                    timeout: 2500,
                    closeWith: ["click", "button"]
                }).show();
            }
        };
    });
});

require(['jquery', 'datatables.net', 'datatables.net-bs4', 'selectize'], function($, DataTable) {

	$(function() {

		$(".transferPostsAndDelete").click(function() {
			$(".deleteUser").modal("show");
			$(".deleteUser").find("input[name='from']").val($(this).data("from"));
		})

		var selectedCountry = [null];

		if($("#selectWithContent").length > 0) {
			$("#selectWithContent option").each(function() {
				if($(this).is(":selected")) {
					selectedCountry = [];
					selectedCountry.push($(this).val());
				}
			});
		}

		$("#selectWithContent").selectize({
			persist: false,
			// items: selectedCountry,
			render: {
				option: function (data, escape) {
					return '<div>' +
						'<span class="image"><img src="' + data.image + '" alt=""></span>' +
						'<span class="title">' + escape(data.text) + '</span>' +
						'</div>';
				},
				item: function (data, escape) {
					return '<div>' +
						'<span class="image"><img src="' + data.image + '" alt=""></span>' +
						escape(data.text) +
						'</div>';
				}
			}
		});

		var tags = [];
		var tempTags = [];

		if($("#postEditor").length > 0) {

			var oldTags = $("input[name='tags']").val().split(",");

			if(oldTags.length > 0) {

				for(var i=0; i<oldTags.length; i++) {
					if($.isNumeric(oldTags[i])) {
						tags.push(oldTags[i]);
						tempTags = tags;
					}
				}

				if(tags.length == 0) tempTags.push(null);
			}
		}

		$('#postTags').selectize({
			persist: false,
			maxItems: null,
			create: true,
			items: tempTags,
			onItemAdd: function(tag) {
				tags.push(tag);
			},
			onItemRemove: function(tag) {
				tags = $.grep(tags, function(value) {
					return value != tag;
				});
			}
		});

		$(".actionLink").click(function() {

			var form = $("<form>");
			var action = $(this).data("action");
			var method = $(this).data("method");
			var token = $("meta[name='csrf-token']").attr("content");

			form.attr("action", action);
			form.attr("method", "post");
			form.append("<input type='hidden' name='_method' value='" + method + "'>");
			form.append("<input type='hidden' name='_token' value='" + token + "'>");

			$(this).append(form);

			if(method == "delete") {
				if(confirm("Are you sure you want to delete?")) {
					return $(this).find(form).submit();
				}
				$(this).find(form).remove();
				return false;
			}

			return $(this).find(form).submit();
		});

		$(".actionForm").submit(function(e) {

			if($(".postContent").length > 0) {
				$(".postContent").val($(".ql-editor").html());
				$("input[name='tags']").val(tags.join(","));
			}

			var inputs = this.querySelectorAll("input[required]");

			if(inputs.length == 0) {
				$(this).find(".submitBtn").prop("disabled", true);
				$(this).find(".submitBtn").val("Processing...");
				return;
			}

			for(var i=0; i<inputs.length; i++) {
				if(inputs[i].value.length > 0) {
					$(this).find(".submitBtn").prop("disabled", true);
					$(this).find(".submitBtn").val("Processing...");
				}
			}
		});

		$("#dttable").DataTable({
			"processing": true,
			"language": {
				"lengthMenu": "<select class='selectNumOfRecords'>" +
					"<option>10</option>" +
					"<option>25</option>" +
					"<option>50</option>" +
					"<option>100</option>" +
					"</select>",
				"search": "",
				"searchPlaceholder": "Search in records"
			},
			'aoColumnDefs': [{
				'bSortable': false,
				'aTargets': [-1],
			}],
		});

		$("select").not("select[class^='ql-']").selectize();

		$("input[type='file']").on("change",function() {
			let fileName = $(this).val().split("\\").pop();
			$(this).next(".custom-file-label").html(fileName);
		});

		$(".dropdown-notifications-unread .nav-unread").hide();
		notifications();
		setInterval(function() { notifications(); }, 20000);

		$(".dropdown-notifications-wrapper").click(function() {
			$(".dropdown-notifications-unread .nav-unread").hide();
		});
	});

	function notifications() {

		var url = "/dashboard/get-notifications";
		var _token = $("meta[name='csrf-token']").attr("content");

		$.ajax({
			url: url,
			type: "post",
			dataType: "json",
			data: {
				_token : _token,
			},
			success: function(response) {

				$(".dropdown-notifications a:not(:last)").remove();
				$(".dropdown-notifications-unread .nav-unread").hide();

				var l = response.length;

				if(hasNew(response)) {
					$(".dropdown-notifications .unreadNotificationsInfo").hide();
					$(".dropdown-notifications-unread .nav-unread").show();
				}

				if(l == 0) {
					$(".dropdown-notifications .unreadNotificationsInfo").show();
				}

				if(l > 0) {
					$(".dropdown-notifications .unreadNotificationsInfo").hide();
				}

				for(var i=0; i<l; i++) {

					var style = response[i].isRead ? "" : "background: #efefef; color: black;";

					var notificationItem = `
						<a href="` + response[i].url + `" class="dropdown-item d-flex" style="` + style + `;">
							<div>
								` + response[i].message + `
								<div class="small text-muted">` + response[i].ago + `</div>
							</div>
						</a>`;

					$(".dropdown-notifications").prepend(notificationItem);
				}
			},
			error: function(response) {
				console.log(response);
			}
		});
	}

	function hasNew(response) {

		for(var i=0; i<response.length; i++) {
			if(!response[i].isRead) {
				return true;
			}
		}

		return false;
	}
});

require(['jquery', 'Quill', 'QuillBlotFormatter', 'colorpickle'], function($, Quill, QuillBlotFormatter, colorpickle) {

	$(function() {
		if ($("#postEditor").length) {

			var toolbarOptions = [
				['bold', 'italic', 'underline', 'strike'],
				['blockquote', 'code-block'],
				[{'header': 1},{'header': 2}],
				[{'list': 'ordered'}, {'list': 'bullet'}],
				[{'script': 'sub'}, {'script': 'super'}],
				[{'indent': '-1'}, {'indent': '+1'}],
				[{'size': ['small', false, 'large', 'huge']}],
				[{'header': [1, 2, 3, 4, 5, 6, false]}],
				['link', 'video', 'formula'],
				[{'color': []}, {'background': []}],
				[{'align': []}],
				['clean']
			];

			// Its disabled because of base64 images
			Quill.register("modules/blotFormatter", QuillBlotFormatter.default);

			var quill = new Quill('#postEditor', {
				placeholder: 'Post content here...',
				theme: 'snow',
				modules: {
					toolbar: toolbarOptions,
					blotFormatter: {}
				},
			});

			if($(".postContent").val().length > 0) {
				quill.clipboard.dangerouslyPasteHTML($(".postContent").val());
			}
		}

		if($(".categoryColor").length) {

		    $(".categoryColor").colorpickle({
                clickToggle: true,
                theme: "engineer",
                showOk: true,
                showCancel: true,
                onTop: true,
                visible: false,
                closeOnOk: true,
                closeOnCancel: true,
                width: "500px",
                modal: true
            });

            if ($(".categoryColor").val().length) {
                $(".categoryColor").colorpickle("setHex", $(".categoryColor").val());
                $(".colorPickerIcon").css("background-color", $(".categoryColor").val());
            }
        }
	});
});
