@extends("layouts.auth")

@section("title", "Forgot | TechnoBlog")

@section("auth_content")
	<div class="page">
		<div class="page-single">
			<div class="container">
				<div class="row">
					<div class="col-lg-12 text-center">
						<img src="{{ asset("assets/images/logo1.png") }}">
					</div>
					<div class="col col-login mx-auto pt-5 pb-7">
						<form class="card" action="{{ route("auth.forgot") }}" method="post">

							@csrf

							<div class="card-body p-6">
								<div class="card-title">Forgot password</div>

								@if ($errors->any())
									<div class="alert alert-danger">
										<ul class="m-0 pl-2">
											@foreach ($errors->all() as $error)
												<li>{{ $error }}</li>
											@endforeach
										</ul>
									</div>
								@endif

								@if(Session::has('forgotInfo'))
									<div class="alert alert-success fade show" role="alert">
										<strong> {{ Session::get('forgotInfo') }} </strong>
										<button type="button" class="close" data-dismiss="alert" aria-label="Close">
										</button>
									</div>
								@endif

								<div class="form-group">
									<label class="form-label" for="exampleInputEmail1">Email address</label>
									<input type="email" name="email" class="form-control" id="" aria-describedby="emailHelp" placeholder="Enter email">
								</div>
								<div class="form-footer">
									<button type="submit" class="btn btn-primary btn-block">Submit</button>
								</div>
							</div>
						</form>
						<div class="text-center text-muted">
							Forget it,
							<a href="{{ route("auth.loginShow") }}">send me back</a> to the sign in screen.
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
@endsection
