@extends('layouts.blog')
@section('title', 'Technoblog | Home')
@section('blog_content')

	<div style="height: 25px;"></div>

	<!-- Main Content Wrapper -->
	<div class="mainContent pb-5">

		<div class="container-fluid">

			<div class="row">
				<!-- Welcome Slider -->
				<div class="col-md-12">

					<div class="welcomeSlider swiper-container">

						<div class="swiper-wrapper">

							@foreach ($latestPosts as $post)

								<div class="swiper-slide">
									<div class="slider-post-wrapper">
										<p class="postCategory" style="background: {{ $post->category->color }};">{{ $post->category->name }}</p><img src="{{ asset("uploads/" . $post->image_link) }}">
										<div class="postOverlay">
											<p><a href="{{ route("blog.post", ["category" => strtolower($post->category->name), "slug" => $post->slug]) }}">{{ $post->title }} </a></p>
											<span>
												<i class="fa fa-clock-o" aria-hidden="true"></i> {{ $post->ago() }}
												&nbsp;&nbsp;&nbsp;&nbsp;
												<i class="fa fa-heart-o" aria-hidden="true"></i> {{ $post->total_likes }} Likes
												&nbsp;&nbsp;
												<i class="fa fa-comment-o" aria-hidden="true"></i> {{ $post->comment->count() }} comments
											</span>
										</div>
									</div>
								</div>

							@endforeach

						</div>

						<div class="swiper-pagination"></div>
						<div class="swiper-button-prev"></div>
						<div class="swiper-button-next"></div>

					</div>

				</div>

				<!-- Videos -->
				@foreach ($blogCategories as $category)

					<style>
						.default_sectionTitle_{{ strtolower($category->name) }}:before,
						.default_sectionTitle_{{ strtolower($category->name) }} span,
						.default_sectionTitle_{{ strtolower($category->name) }} a {
							background: {{ $category->color }};
							color: {{ $category->color }};
						}
					</style>

					<header class="default_sectionTitle default_sectionTitle_{{ strtolower($category->name) }}">
						<span>{{ $category->name }}</span>
						<a class="elemWithTooltip" data-tooltip-info="right-Explore More" href="{{ route("blog.category", ["category" => strtolower($category->name)]) }}">More</a>
					</header>

					@foreach ($posts as $post)

						@if($post->category->name == $category->name)

							<div class="col-md-4 post-item">
								<div class="card">
									<div class="card-img-top-wrapper">
										<img class="card-img-top" src="{{ asset("uploads/" . $post->image_link) }}" alt="Card image cap">
									</div>
									<div class="card-body">
										<h5 class="card-title"><a href="{{ route("blog.post", ["category" => strtolower($post->category->name), "slug" => $post->slug]) }}" class="blogSectionCardLink">{{ $post->title }}</a></h5>
										<p class="card-text">{!! str_limit($post->content, 90) !!}</p>
									</div>
									<div class="card-footer">
										<small class="text-muted">{{ $post->ago() }}</small>
									</div>
								</div>
							</div>

						@endif

					@endforeach

				@endforeach

			</div>

		</div>

	</div>

@endsection
