@extends("layouts.dashboard")

@section("title", "Add new post - Dashboard | TechnoBlog")

@section("dashboard_content")

<div class="my-3 my-md-5">

		<div class="container">

			<div class="row">

				<div class="col-sm-12">

                    @if(!$post->review->is_passed_all_phases)
                        <p class="text-center" style="font-size: 17px;">
                            Current phase: {{ $post->review->getPhase()->name }}
                            @if($post->review->canReview())
                                <a href="javascript:void(0)" class="btn btn-primary actionLink" style="cursor: pointer;" data-action="{{ route("dashboard.posts.confirm", ["id" => $post->id]) }}" data-method="patch"><i class="text-light fe fe-check"></i> Confirm </a>
                            @endif
                        </p>
                    @endif

					<div class="card">

						<nav aria-label="breadcrumb">
							<ol class="breadcrumb" style="border-radius: 0px !important;">
								<li class="breadcrumb-item">
									<a href="{{ route("dashboard.index") }}">Dashboard</a>
								</li>
								<li class="breadcrumb-item">
									<a href="{{ route("dashboard.posts.index") }}">Posts</a>
								</li>
								<li class="breadcrumb-item active" aria-current="page">Edit Post</li>
							</ol>
						</nav>

						<div class="card-header">
							<h3 class="card-title">Edit Post</h3>
						</div>

						<form class="actionForm" action="{{ route("dashboard.posts.edit", ["id" => $post->id]) }}" method="post" enctype="multipart/form-data" accept-charset="UTF-8">

                            @method("patch")
							@csrf

							<div class="row p-5">

								<div class="col-md-4">

									<div class="form-group">
										<label class="form-label">Title</label>
										<input type="text" value="{{ old("title", $post->title) }}" name="title" class="form-control" required>
									</div>

									<div class="form-group">
										<label class="form-label">Upload Image</label>
										<div class="custom-file">
											<input type="file" class="custom-file-input" name="image">
											<label class="custom-file-label">Choose file</label>
										</div>
									</div>

									<div class="form-group">
										<label class="form-label">Select Category</label>
										<select name="category">
											@foreach ($categories as $category)
												<option value="{{ $category->id }}" {{ old("category", $post->category->id) == $category->id ? "selected" : "" }}>{{ $category->name }}</option>
											@endforeach
										</select>
									</div>

									<div class="form-group">
										<label class="form-label">Select or create new tags</label>
										<select id="postTags">
											@foreach ($tags as $tag)
												<option value="{{ $tag->id }}">{{ $tag->name }}</option>
											@endforeach
										</select>
										<input type="hidden" name="tags" value="{{ old("tags", implode(",", $postTags)) }}">
									</div>

								</div>

								<div class="col-md-8">
									<label class="form-label">Content</label>
									<!-- Quill rich text editor -->
									<div id="postEditor" class="pr-5" style="height: 500px;"></div>
									<input type="hidden" class="postContent" name="post_content" value='{{ old("post_content", $post->content) }}'>
								</div>

								<div class="col mt-5">
									<div class="form-group border-top">
										<div class="float-right pt-5">
											<input type="submit" value="Edit Post" class="submitBtn submitNewPost btn btn-primary">
										</div>
									</div>
								</div>

							</div>

						</form>

					</div>

				</div>

			</div>

		</div>

	</div>

@endsection
