@extends("layouts.dashboard")

@section("title", "Settings - Dashboard | TechnoBlog")

@section("dashboard_content")

    <div class="my-3 my-md-5">

        <div class="container">

            <div class="row">

                <div class="col-sm-12">

                    <div class="card">

                        <div class="card-header">
                            <h3 class="card-title font-weight-bold">Settings</h3>
                        </div>

                        <div class="card-body">

                            <div class="row">
                                <div class="col-md-4">
                                    <div class="nav flex-column nav-pills" id="v-pills-tab" role="tablist"
                                         aria-orientation="vertical">
                                        <a class="nav-link active pt-2 pb-2" id="v-pills-home-tab" data-toggle="pill"
                                           href="#v-pills-home" role="tab" aria-controls="v-pills-home"
                                           aria-selected="true">Profile</a>
                                        <a class="nav-link pt-2 pb-2" id="v-pills-profile-tab" data-toggle="pill"
                                           href="#v-pills-profile" role="tab" aria-controls="v-pills-profile"
                                           aria-selected="false">Account</a>
                                        @if(auth()->user()->hasPermission("access_all_phases"))
                                            <a class="nav-link pt-2 pb-2" id="v-pills-phases-tab" data-toggle="pill"
                                               href="#v-pills-phases" role="tab" aria-controls="v-pills-phases"
                                               aria-selected="false">Phases</a>
                                        @endif

                                        @if(auth()->user()->hasPermission("access_all_post_securities"))
                                            <a class="nav-link pt-2 pb-2" id="v-pills-post-security-tab" data-toggle="pill"
                                               href="#v-pills-post-security" role="tab" aria-controls="v-pills-post-security"
                                               aria-selected="false">Post Security</a>
                                        @endif
                                    </div>
                                </div>

                                <div class="col-md-8">
                                    <div class="tab-content" id="v-pills-tabContent">
                                        <div class="tab-pane fade show active" id="v-pills-home" role="tabpanel"
                                             aria-labelledby="v-pills-home-tab">

                                            <form class="actionForm" action="{{ route("dashboard.settings.personal") }}"
                                                  method="post" accept-charset="UTF-8">

                                                @method("patch")
                                                @csrf

                                                <fieldset class="form-fieldset">

                                                    <h4 class="font-weight-normal border-bottom pb-2">Personal
                                                        Information</h4>

                                                    <div class="row">

                                                        <div class="col-md-4">
                                                            <div class="form-group">
                                                                <label class="form-label">Name</label>
                                                                <input type="text"
                                                                       value="{{ old("name", $userProfile->user->name) }}"
                                                                       name="name" class="form-control">
                                                            </div>
                                                        </div>

                                                        <div class="col-md-4">
                                                            <div class="form-group">
                                                                <label class="form-label">Surname</label>
                                                                <input type="text"
                                                                       value="{{ old("surname", $userProfile->user->surname) }}"
                                                                       name="surname" class="form-control">
                                                            </div>
                                                        </div>

                                                        <div class="col-md-4">
                                                            <div class="form-group">
                                                                <label class="form-label">Mobile Number Country
                                                                    Code</label>
                                                                <select class="selectData" id="selectWithContent"
                                                                        name="mobile_number_country">
                                                                    <option value=""></option>
                                                                    @foreach ($countries as $code => $name)
                                                                        <option value="{{ $code }}"
                                                                                {{ (old("mobile_number_country", $userProfile->user->country_code) == $code) ? "selected" : "" }} data-data='{"image": "/assets/images/flags/{{ strtolower($code) }}.svg"}'>{{ $name }}</option>
                                                                    @endforeach
                                                                </select>
                                                            </div>
                                                        </div>

                                                        <div class="col-md-4">
                                                            <div class="form-group">
                                                                <label class="form-label">Mobile Number</label>
                                                                <input type="text"
                                                                       value="{{ old("mobile_number", $userProfile->user->mobile_number) }}"
                                                                       name="mobile_number" class="form-control">
                                                            </div>
                                                        </div>

                                                        <div class="col-md-8">
                                                            <div class="form-group">
                                                                <label class="form-label">Short Bio</label>
                                                                <input type="text"
                                                                       value="{{ old("short_bio", $userProfile->short_bio) }}"
                                                                       name="short_bio" class="form-control"
                                                                       autocomplete="off">
                                                            </div>
                                                        </div>

                                                        <div class="col-md-8">
                                                            <div class="form-group">
                                                                <label class="form-label">Public Profile Link</label>
                                                                <div class="input-group">
																<span class="input-group-prepend" id="basic-addon3">
																	<span class="input-group-text">https://technoblog.com/profile/</span>
																</span>
                                                                    <input type="text"
                                                                           value="{{ old("profile_link", $userProfile->profile_link) }}"
                                                                           name="profile_link" class="form-control"
                                                                           autocomplete="off">
                                                                </div>
                                                            </div>
                                                        </div>

                                                        <div class="col-md-12">
                                                            <div class="form-group mb-0 float-right">
                                                                <input type="submit" value="Submit"
                                                                       class="submitBtn btn btn-primary">
                                                            </div>
                                                        </div>

                                                    </div>

                                                </fieldset>

                                            </form>

                                            <form class="actionForm" action="{{ route("dashboard.settings.photos") }}"
                                                  method="post" enctype="multipart/form-data">

                                                @method("patch")
                                                @csrf

                                                <fieldset class="form-fieldset">

                                                    <h4 class="font-weight-normal border-bottom pb-2">Photos</h4>

                                                    <div class="row">

                                                        <div class="col-md-6">
                                                            <div class="form-group">
                                                                <label class="form-label">Upload Profile Picture</label>
                                                                <div class="custom-file">
                                                                    <input type="file" class="custom-file-input"
                                                                           name="profile_image">
                                                                    <label class="custom-file-label">Choose file</label>
                                                                </div>
                                                            </div>
                                                        </div>

                                                        <div class="col-md-6">
                                                            <div class="form-group">
                                                                <label class="form-label">Upload Cover Picture</label>
                                                                <div class="custom-file">
                                                                    <input type="file" class="custom-file-input"
                                                                           name="cover_image">
                                                                    <label class="custom-file-label">Choose file</label>
                                                                </div>
                                                            </div>
                                                        </div>

                                                        <div class="col-md-12">
                                                            <div class="form-group mb-0 float-right">
                                                                <input type="submit" value="Submit"
                                                                       class="submitBtn btn btn-primary">
                                                            </div>
                                                        </div>

                                                    </div>

                                                </fieldset>

                                            </form>

                                            <form class="actionForm" action="{{ route("dashboard.settings.social") }}"
                                                  method="post" accept-charset="UTF-8">

                                                @method("patch")
                                                @csrf

                                                <fieldset class="form-fieldset">

                                                    <h4 class="font-weight-normal border-bottom pb-2">Social Site
                                                        Links</h4>

                                                    <div class="row">

                                                        <div class="col-md-6">
                                                            <div class="form-group">
                                                                <label class="form-label">Facebook</label>
                                                                <div class="input-group">
																<span class="input-group-prepend" id="basic-addon3">
																	<span
                                                                        class="input-group-text">https://facebook.com/</span>
																</span>
                                                                    <input type="text" class="form-control"
                                                                           name="facebook"
                                                                           value="{{ old("facebook", $userProfile->facebook_link) }}">
                                                                </div>
                                                            </div>
                                                        </div>

                                                        <div class="col-md-6">
                                                            <div class="form-group">
                                                                <label class="form-label">Instagram</label>
                                                                <div class="input-group">
																<span class="input-group-prepend" id="basic-addon3">
																	<span class="input-group-text">https://instagram.com/</span>
																</span>
                                                                    <input type="text" class="form-control"
                                                                           name="instagram"
                                                                           value="{{ old("instagram", $userProfile->instagram_link) }}">
                                                                </div>
                                                            </div>
                                                        </div>

                                                        <div class="col-md-6 mt-3">
                                                            <div class="form-group">
                                                                <label class="form-label">Twitter</label>
                                                                <div class="input-group">
																<span class="input-group-prepend" id="basic-addon3">
																	<span
                                                                        class="input-group-text">https://twitter.com/</span>
																</span>
                                                                    <input type="text" class="form-control"
                                                                           name="twitter"
                                                                           value="{{ old("twitter", $userProfile->twitter_link) }}">
                                                                </div>
                                                            </div>
                                                        </div>

                                                        <div class="col-md-6 mt-3">
                                                            <div class="form-group">
                                                                <label class="form-label">Youtube</label>
                                                                <div class="input-group">
																<span class="input-group-prepend" id="basic-addon3">
																	<span
                                                                        class="input-group-text">https://youtube.com/</span>
																</span>
                                                                    <input type="text" class="form-control"
                                                                           name="youtube"
                                                                           value="{{ old("youtube", $userProfile->youtube_link) }}">
                                                                </div>
                                                            </div>
                                                        </div>

                                                        <div class="col-md-6 mt-3">
                                                            <div class="form-group">
                                                                <label class="form-label">Skype</label>
                                                                <div class="input-group">
																<span class="input-group-prepend" id="basic-addon3">
																	<span class="input-group-text">@</span>
																</span>
                                                                    <input type="text" class="form-control" name="skype"
                                                                           value="{{ old("skype", $userProfile->skype_link) }}">
                                                                </div>
                                                            </div>
                                                        </div>

                                                        <div class="col-md-12">
                                                            <div class="form-group mb-0 float-right">
                                                                <input type="submit" value="Submit"
                                                                       class="submitBtn btn btn-primary">
                                                            </div>
                                                        </div>

                                                    </div>

                                                </fieldset>

                                            </form>

                                        </div>

                                        <div class="tab-pane fade" id="v-pills-profile" role="tabpanel"
                                             aria-labelledby="v-pills-profile-tab">

                                            <form class="actionForm" action="{{ route("dashboard.settings.username") }}"
                                                  method="post" accept-charset="UTF-8">

                                                @method("patch")
                                                @csrf

                                                <fieldset class="form-fieldset">

                                                    <h4 class="font-weight-normal border-bottom pb-2">Username</h4>

                                                    <h6 class="font-weight-normal text-muted">After changing your
                                                        username you will be logged out automatically.</h6>

                                                    <div class="row">


                                                        <div class="col-md-6">
                                                            <div class="form-group">
                                                                <label class="form-label">Username</label>
                                                                <input type="text"
                                                                       value="{{ old("username", $userProfile->user->username) }}"
                                                                       name="username" class="form-control">
                                                            </div>
                                                        </div>

                                                        <div class="col-md-12">
                                                            <div class="form-group mb-0 float-right">
                                                                <input type="submit" value="Submit"
                                                                       class="submitBtn btn btn-primary">
                                                            </div>
                                                        </div>

                                                    </div>

                                                </fieldset>

                                            </form>

                                            <form class="actionForm" action="{{ route("dashboard.settings.password") }}"
                                                  method="post" accept-charset="UTF-8">

                                                @method("patch")
                                                @csrf

                                                <fieldset class="form-fieldset">

                                                    <h4 class="font-weight-normal border-bottom pb-2">Password</h4>

                                                    <h6 class="font-weight-normal text-muted">After changing your
                                                        password you will be logged out automatically.</h6>

                                                    <div class="row">

                                                        <div class="col-md-4">
                                                            <div class="form-group">
                                                                <label class="form-label">Current Password <span
                                                                        class="form-required">*</span></label>
                                                                <input type="password" class="form-control"
                                                                       name="current_password" autocomplete="off"
                                                                       required>
                                                            </div>
                                                        </div>

                                                        <div class="col-md-4">
                                                            <div class="form-group">
                                                                <label class="form-label">New Password <span
                                                                        class="form-required">*</span></label>
                                                                <input type="password" class="form-control"
                                                                       name="password" autocomplete="off" required>
                                                            </div>
                                                        </div>

                                                        <div class="col-md-4">
                                                            <div class="form-group">
                                                                <label class="form-label">Repeat New Password <span
                                                                        class="form-required">*</span></label>
                                                                <input type="password" class="form-control"
                                                                       name="password_confirmation" autocomplete="off"
                                                                       required>
                                                            </div>
                                                        </div>

                                                        <div class="col-md-12">
                                                            <div class="form-group mb-0 float-right">
                                                                <input type="submit" value="Submit"
                                                                       class="submitBtn btn btn-primary">
                                                            </div>
                                                        </div>

                                                    </div>

                                                </fieldset>

                                            </form>

                                            <form class="actionForm" action="{{ route("dashboard.settings.email") }}"
                                                  method="post" accept-charset="UTF-8">

                                                @method("patch")
                                                @csrf

                                                <fieldset class="form-fieldset">

                                                    <h4 class="font-weight-normal border-bottom pb-2">E-mail</h4>

                                                    <h6 class="font-weight-normal text-muted">This is where lost
                                                        password requests will be sent. After changing your e-mail you
                                                        will be logged out automatically.</h6>

                                                    <div class="row">

                                                        <div class="col-md-4">
                                                            <div class="form-group">
                                                                <label class="form-label">E-mail</label>
                                                                <input type="email"
                                                                       value="{{ old("email", $userProfile->user->email) }}"
                                                                       name="email" class="form-control">
                                                            </div>
                                                        </div>

                                                        <div class="col-md-12">
                                                            <div class="form-group mb-0 float-right">
                                                                <input type="submit" value="Submit"
                                                                       class="submitBtn btn btn-primary">
                                                            </div>
                                                        </div>

                                                    </div>

                                                </fieldset>

                                            </form>

                                            <fieldset class="form-fieldset border-danger">
                                                <h4 class="font-weight-normal border-bottom pb-2 text-danger">Danger
                                                    Zone</h4>
                                                <h5 class="font-weight-normal text-danger">Before you delete your
                                                    account you need to choose any admin or editor to transfer your
                                                    posts. After that all informations related to your account will be
                                                    deleted permanently.</h5>
                                                <a href="javascript:void(0)" data-from="{{ auth()->user()->id }}"
                                                   class="btn btn-danger transferPostsAndDelete mt-2">Delete account</a>
                                            </fieldset>

                                            <div class="modal fade deleteUser" id="transferPosts" tabindex="-1"
                                                 role="dialog" aria-hidden="true">

                                                <div class="modal-dialog modal-dialog-centered" role="document">

                                                    <div class="modal-content">

                                                        <div class="modal-header">
                                                            <h5 class="modal-title" id="exampleModalLabel">Delete
                                                                Account</h5>
                                                            <button type="button" class="close" data-dismiss="modal"
                                                                    aria-label="Close"></button>
                                                        </div>

                                                        <div class="modal-body">

                                                            <form id="transferPosts"
                                                                  action="{{ route("dashboard.settings.transfer") }}"
                                                                  method="post">

                                                                @csrf

                                                                @if (auth()->user()->post->count() > 0)
                                                                    <div class="form-group">
                                                                        <label class="form-label">Transfer your posts to
                                                                            any admin or editor</label>
                                                                        <select class="selectData"
                                                                                id="selectWithContent" name="to">
                                                                            @foreach ($adminAndEditors as $user)
                                                                                <option value="{{ $user->id }}"
                                                                                        {{ (old("to") == $user->id) ? "selected" : "" }} data-data='{"image": "/uploads/users/{{ $user->userProfile->profile_photo_link }}"}'>{{ $user->getFullName() }}</option>
                                                                            @endforeach
                                                                        </select>
                                                                    </div>
                                                                @endif

                                                                <input type="hidden" name="from" value="">

                                                                <div class="form-group">
                                                                    <label class="form-label">Confirm Password</label>
                                                                    <input type="password" class="form-control"
                                                                           name="password" autocomplete="off" required>
                                                                </div>

                                                                <div class="modal-footer pb-0">
                                                                    <button type="button" class="btn btn-secondary"
                                                                            data-dismiss="modal">Close
                                                                    </button>
                                                                    <input type="submit" class="btn btn-danger"
                                                                           value="Delete">
                                                                </div>

                                                            </form>

                                                        </div>

                                                    </div>

                                                </div>

                                            </div>
                                        </div>

                                        @if (auth()->user()->hasPermission("access_all_phases"))
                                            <div class="tab-pane fade" id="v-pills-phases" role="tabpanel"
                                                 aria-labelledby="v-pills-phases-tab">

                                                <fieldset class="form-fieldset">

                                                    <h4 class="font-weight-normal border-bottom pb-4">
                                                        Phases
                                                        <span class="triggerPhaseModal float-right mb-2 d-inline-block btn btn-sm btn-primary">Create New</span>
                                                    </h4>

                                                    <div class="modal fade phaseModal" tabindex="-1" role="dialog" aria-hidden="true">

                                                        <div class="modal-dialog modal-dialog-centered" role="document">

                                                            <div class="modal-content">

                                                                <div class="modal-header">
                                                                    <h5 class="modal-title" id="exampleModalLabel">Create new phase</h5>
                                                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"></button>
                                                                </div>

                                                                <div class="modal-body">

                                                                    <form action="{{ route("dashboard.settings.phase.store") }}"
                                                                          method="post">
                                                                        @csrf

                                                                        <input type="hidden" name="phase_id">

                                                                        <label class="form-label">Name</label>
                                                                        <input type="text" class="form-control"
                                                                               name="name" autocomplete="off" required>

                                                                        <label class="form-label mt-2">User role to review</label>
                                                                        <select class="selectData" name="reviewer_role_id">
                                                                            <option value=""></option>
                                                                            @foreach ($userRoles as $userRole)
                                                                                <option
                                                                                    value="{{ $userRole->id }}"
                                                                                    {{ (old("reviewer_role_id") == $userRole->id) ? "selected" : "" }}
                                                                                >
                                                                                    {{ ucfirst($userRole->name) }}
                                                                                </option>
                                                                            @endforeach
                                                                        </select>

                                                                        <div class="modal-footer pb-0">
                                                                            <button type="button" class="btn btn-secondary"
                                                                                    data-dismiss="modal">Close
                                                                            </button>
                                                                            <input type="submit" class="btn btn-primary"
                                                                                   value="Submit">
                                                                        </div>

                                                                    </form>

                                                                </div>

                                                            </div>

                                                        </div>

                                                    </div>

                                                    <table id="dttable" class="table table-hover table-outline table-vcenter text-nowrap card-table">
                                                        <thead>
                                                            <tr>
                                                                <th>Name</th>
                                                                <th>Reviewer</th>
                                                                <th>Actions</th>
                                                            </tr>
                                                        </thead>
                                                        <tbody>
                                                            @foreach($phases as $phase)
                                                                <tr>
                                                                    <td>{{ $phase->name }}</td>
                                                                    <td>{{ ucfirst($phase->reviewer->name) }}</td>
                                                                    <td class="text-center">
                                                                        <div class="item-action dropdown">
                                                                            <a href="javascript:void(0)" data-toggle="dropdown" class="icon" aria-expanded="false"><i class="fe fe-more-vertical"></i></a>
                                                                            <div class="dropdown-menu dropdown-menu-right" x-placement="bottom-end" style="position: absolute; transform: translate3d(15px, 20px, 0px); top: 0px; left: 0px; will-change: transform;">
                                                                                <a href="javascript:void(0)" data-phase-id="{{ $phase->id }}" data-phase-name="{{ $phase->name }}" data-phase-reviewer="{{ $phase->reviewer->id }}" class="triggerPhaseModal dropdown-item"><i class="dropdown-icon fe fe-edit"></i> Edit</a>
                                                                                <a href="javascript:void(0)" class="actionLink dropdown-item" style="cursor: pointer;" data-action="{{ route("dashboard.settings.phase.destroy", ["id" => $phase->id]) }}" data-method="delete"><i class="dropdown-icon fe fe-trash-2 text-danger"></i> Delete </a>
                                                                            </div>
                                                                        </div>
                                                                    </td>
                                                                </tr>
                                                            @endforeach
                                                        </tbody>
                                                    </table>

                                                </fieldset>
                                            </div>
                                        @endif

                                        @if(auth()->user()->hasPermission("access_all_post_securities"))
                                            <div class="tab-pane fade" id="v-pills-post-security" role="tabpanel"
                                                 aria-labelledby="v-pills-post-security-tab">
                                                <fieldset class="form-fieldset">

                                                    <h4 class="font-weight-normal border-bottom pb-4">
                                                        Post security
                                                        <span class="triggerPostSecurityModal float-right mb-2 d-inline-block btn btn-sm btn-primary">Create New</span>
                                                    </h4>

                                                    <div class="modal fade postSecurityModal" tabindex="-1" role="dialog" aria-hidden="true">

                                                        <div class="modal-dialog modal-dialog-centered" role="document">

                                                            <div class="modal-content">

                                                                <div class="modal-header">
                                                                    <h5 class="modal-title" id="exampleModalLabel">Create new post security</h5>
                                                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"></button>
                                                                </div>

                                                                <div class="modal-body">

                                                                    <form class="postSecurityStore"
                                                                          action="{{ route("dashboard.settings.post-security.store") }}"
                                                                          method="post">
                                                                        @csrf

                                                                        <input type="hidden" name="post_security_id">

                                                                        <label class="form-label">User role to be reviewed</label>
                                                                        <select class="selectData" name="role_id_to_be_reviewed">
                                                                            <option value=""></option>
                                                                            @foreach ($userRoles as $userRole)
                                                                                <option
                                                                                    value="{{ $userRole->id }}"
                                                                                    {{ (old("role_id_to_be_reviewed") == $userRole->id) ? "selected" : "" }}
                                                                                >
                                                                                    {{ ucfirst($userRole->name) }}
                                                                                </option>
                                                                            @endforeach
                                                                        </select>

                                                                        <label class="form-label mt-2">Select phases</label>
                                                                        <select class="phasesSelect" multiple>
                                                                            <option value=""></option>
                                                                            @foreach ($phases as $phase)
                                                                                <option
                                                                                    value="{{ $phase->id }}">
                                                                                    {{ $phase->name }}
                                                                                </option>
                                                                            @endforeach
                                                                        </select>
                                                                        <input type="hidden" name="phase_ids">

                                                                        <div class="modal-footer pb-0">
                                                                            <button type="button" class="btn btn-secondary"
                                                                                    data-dismiss="modal">Close
                                                                            </button>
                                                                            <input type="submit" class="btn btn-primary"
                                                                                   value="Submit">
                                                                        </div>

                                                                    </form>

                                                                </div>

                                                            </div>

                                                        </div>

                                                    </div>

                                                    <table id="dttable" class="dttable table table-hover table-outline table-vcenter text-nowrap card-table">
                                                        <thead>
                                                            <tr>
                                                                <th>To be reviewed</th>
                                                                <th>Phases</th>
                                                                <th>Actions</th>
                                                            </tr>
                                                        </thead>
                                                        <tbody>
                                                            @foreach($postSecurities as $postSecurity)
                                                                <tr>
                                                                    <td>{{ ucfirst($postSecurity->role->name) }}</td>
                                                                    <td>{{ $postSecurity->phase_names }}</td>
                                                                    <td class="text-center">
                                                                        <div class="item-action dropdown">
                                                                            <a href="javascript:void(0)" data-toggle="dropdown" class="icon" aria-expanded="false"><i class="fe fe-more-vertical"></i></a>
                                                                            <div class="dropdown-menu dropdown-menu-right" x-placement="bottom-end" style="position: absolute; transform: translate3d(15px, 20px, 0px); top: 0px; left: 0px; will-change: transform;">
                                                                                <a href="javascript:void(0)" data-post-security-id="{{ $postSecurity->id }}" data-post-security-role="{{ $postSecurity->role->id }}" data-post-security-phase-ids="{{ $postSecurity->phase_ids }}" class="triggerPostSecurityModal dropdown-item"><i class="dropdown-icon fe fe-edit"></i> Edit</a>
                                                                                <a href="javascript:void(0)" class="actionLink dropdown-item" style="cursor: pointer;" data-action="{{ route("dashboard.settings.post-security.destroy", ["id" => $phase->id]) }}" data-method="delete"><i class="dropdown-icon fe fe-trash-2 text-danger"></i> Delete </a>
                                                                            </div>
                                                                        </div>
                                                                    </td>
                                                                </tr>
                                                            @endforeach
                                                        </tbody>
                                                    </table>

                                                </fieldset>
                                            </div>
                                        @endif
                                    </div>
                                </div>
                            </div>

                        </div>

                    </div>

                </div>

            </div>

        </div>

    </div>

@endsection
