<div class="header py-4">
    <div class="container">
        <div class="d-flex">
            <a class="header-brand text-primary" href="#">TechnoBlog</a>
            <div class="d-flex order-lg-2 ml-auto">
                <div class="dropdown dropdown-notifications-wrapper d-none d-md-flex">
                    <a class="nav-link dropdown-notifications-unread icon" data-toggle="dropdown">
                        <i class="fe fe-bell"></i>
                        <span class="nav-unread"></span>
                    </a>
                    <div class="dropdown-menu dropdown-notifications dropdown-menu-right dropdown-menu-arrow">
                        <p class='text-center unreadNotificationsInfo'>No unread notifications</p>
                        <div class="dropdown-divider"></div>
                        <a href="{{ route("dashboard.notifications.index") }}" class="dropdown-item text-center text-muted-dark">See all</a>
                    </div>
                </div>
                <div class="dropdown">
                    <a href="#" class="nav-link pr-0 leading-none" data-toggle="dropdown">

                        @if(!empty(auth()->user()->userProfile->profile_photo_link))
                            <span class="avatar" style="background-image: url(/uploads/users/{{ auth()->user()->userProfile->profile_photo_link }})"></span>
                        @else
                            <span class="avatar">{{ strtoupper(auth()->user()->name[0]) . strtoupper(auth()->user()->surname[0]) }}</span>
                        @endif

                        <span class="ml-2 d-none d-lg-block">
					  		<span class="text-default">{{ auth()->user()->getFullName() }}</span>
							<small class="text-muted d-block mt-1">{{ ucfirst(auth()->user()->role->name) }}</small>
						</span>
                    </a>
                    <div class="dropdown-menu dropdown-menu-right dropdown-menu-arrow">
                        <a class="dropdown-item" href="{{ route("blog.user-profile", ["profileLink" => auth()->user()->userProfile->profile_link]) }}" target="_blank">
                            <i class="dropdown-icon fe fe-user"></i> Public Profile
                        </a>
                        <a class="dropdown-item" href="{{ route("dashboard.settings.index") }}">
                            <i class="dropdown-icon fe fe-settings"></i> Settings
                        </a>
                        <div class="dropdown-divider"></div>
                        <a class="dropdown-item"
                           href="javascript:void(0)"
                           onclick="
								event.preventDefault();
								document.getElementById('logout-form').submit();
							">
                            <i class="dropdown-icon fe fe-log-out"></i> Logout
                        </a>
                        <form id="logout-form" action="{{ route("auth.logout") }}" method="post">
                            @csrf
                        </form>
                    </div>
                </div>
            </div>
            <a href="#" class="header-toggler d-lg-none ml-3 ml-lg-0" data-toggle="collapse" data-target="#headerMenuCollapse">
                <span class="header-toggler-icon"></span>
            </a>
        </div>
    </div>
</div>
<div class="header collapse d-lg-flex p-0" id="headerMenuCollapse">
    <div class="container">
        <div class="row align-items-center">
            <div class="col-lg order-lg-first">
                <ul class="nav nav-tabs border-0 flex-column flex-lg-row">

                    <li class="nav-item">
                        <a href="{{ route("dashboard.index") }}" class="nav-link {{ request()->is('dashboard') ? 'active' : '' }}">
                            <i class="fe fe-home"></i> Home
                        </a>
                    </li>

                    @if(auth()->user()->hasPermission("access_all_users"))
                        <li class="nav-item">
                            <a href="{{ route("dashboard.users.index") }}" class="nav-link {{ request()->is(['dashboard/users', 'dashboard/users/*']) ? 'active' : '' }}">
                                <i class="fe fe-users"></i> Users
                            </a>
                        </li>
                    @endif

                    <li class="nav-item">
                        <a href="{{ route("dashboard.posts.index") }}" class="nav-link {{ request()->is(['dashboard/posts', 'dashboard/posts/*']) ? 'active' : '' }}">
                            <i class="fe fe-database"></i> Posts
                        </a>
                    </li>

                    @if(auth()->user()->hasPermission("access_all_categories"))
                        <li class="nav-item">
                            <a href="{{ route("dashboard.categories.index") }}" class="nav-link {{ request()->is(['dashboard/categories', 'dashboard/categories/*']) ? 'active' : '' }}">
                                <i class="fe fe-layers"></i> Categories
                            </a>
                        </li>
                    @endif

                    <li class="nav-item">
                        <a href="{{ route("dashboard.comments.index") }}" class="nav-link {{ request()->is(['dashboard/comments', 'dashboard/comments/*']) ? 'active' : '' }}">
                            <i class="fe fe-message-circle"></i> Comments
                        </a>
                    </li>

                    <li class="nav-item">
                        <a href="{{ route("dashboard.tags.index") }}" class="nav-link {{ request()->is(['dashboard/tags', 'dashboard/tags/*']) ? 'active' : '' }}">
                            <i class="fe fe-tag"></i> Tags
                        </a>
                    </li>

                    @if(auth()->user()->hasRole("admin"))
                        <li class="nav-item">
                            <a href="{{ route("dashboard.companies.index") }}" class="nav-link {{ request()->is(['dashboard/companies', 'dashboard/companies/*']) ? 'active' : '' }}">
                                <i class="fe fe-briefcase"></i> Companies
                            </a>
                        </li>
                    @endif
                </ul>
            </div>
        </div>
    </div>
</div>
