@extends("layouts.auth")

@section("title", "Login | TechnoBlog")

@section("auth_content")
	<div class="page">
		<div class="page-single">
			<div class="container">
				<div class="row">
					<div class="col col-login mx-auto">
						<div class="text-center mb-6">
							<img src="/assets/images/logo.png">
						</div>
						<form class="card" action="{{ route("auth.login") }}" method="post" accept-charset="utf-8">

							@csrf

							<div class="card-body p-6">
								<div class="card-title">Login to your account</div>

								@if(Session::has('isActiveError'))
									<div class="alert alert-danger alert-dismissible fade show" role="alert">
										<strong> {{ Session::get('isActiveError') }} </strong>
										<button type="button" class="close" data-dismiss="alert" aria-label="Close"></button>
									</div>
								@endif

								@if(Session::has('loginError'))
									<div class="alert alert-error fade show" role="alert">
										<strong> {{ Session::get('loginError') }} </strong>
										<button type="button" class="close" data-dismiss="alert" aria-label="Close">
										</button>
									</div>
								@endif

								<div class="form-group">
									<label class="form-label">Username</label>
									<input id="username" type="text" tabindex="1" class="form-control{{ Session::has('usernameError') ? ' is-invalid' : '' }}" name="username" value="{{ old('username') }}" autocomplete="off" required autofocus>
									@if(Session::has('usernameError'))
										<span class="invalid-feedback" role="alert">
											<strong>{{ Session::get('usernameError') }}</strong>
										</span>
									@endif
								</div>
								<div class="form-group">
									<label class="form-label">
										Password
										<a href="/auth/forgot" tabindex="-1" class="float-right small">I forgot password</a>
									</label>
									<input id="password" type="password" tabindex="2" class="form-control{{ Session::has('passwordError') ? ' is-invalid' : '' }}" name="password" autocomplete="off" required>
									@if(Session::has('passwordError'))
										<span class="invalid-feedback" role="alert">
											<strong>{{ Session::get('passwordError') }}</strong>
										</span>
									@endif
								</div>
								<div class="form-group">
									<label class="custom-control custom-checkbox">
										<input class="custom-control-input" type="checkbox" name="remember" id="remember" {{ old('remember') ? 'checked' : '' }}>
										<span class="custom-control-label">Remember me</span>
									</label>
								</div>
								<div class="form-footer">
									<input type="submit" value="Sign in" class="btn btn-primary btn-block">
								</div>
							</div>

						</form>
					</div>
				</div>
			</div>
		</div>
	</div>
@endsection
