<?php

namespace App\Http\Requests\Dashboard;

use Illuminate\Foundation\Http\FormRequest;

class PhaseRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        if ($this->has("phase_id") && !is_null($this->request->get("phase_id"))) {
            return auth()->user()->hasPermission("edit_phase");
        }

        return auth()->user()->hasPermission("create_phase");
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        $rules = [
            "name" => "required|min:2|unique:phases",
            "reviewer_role_id" => "required|exists:roles,id",
        ];

        if ($this->has("phase_id") && !is_null($this->request->get("phase_id"))) {
            $rules["name"] = "required|min:2|unique:phases,name," . $this->request->get("phase_id");
            $rules["phase_id"] = "required|exists:phases,id";
        }

        return $rules;
    }
}
